﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    

    public class BiomonitoringManager: WorkflowManager
    {
        public BiomonitoringManager() 
        {
            _defaultSortField = "WKF_CASE_ID";
        }
        
        /// <summary>
        /// Gets all the referral indicators for the referral id.
        /// </summary>
        /// <param name="referralId"></param>
        /// <returns>IEnumerable<sting></sting></returns>
        public IEnumerable<string> GetReferralIndicators(int referralId)
        {
            using (_db = GetDataContext())
            {
                DataLoadOptions lo = new DataLoadOptions();
                lo.LoadWith<REFERRAL>(i => i.REFERRAL_DETAILs);
                lo.LoadWith<REFERRAL_DETAIL>(i => i.STD_HEALTHFACTOR);
                _db.LoadOptions = lo;
                _db.ObjectTrackingEnabled = false;
                REFERRAL Referral = (from t in _db.REFERRALs where t.REFERRAL_ID==referralId select t).FirstOrDefault();
                return (from t in Referral.REFERRAL_DETAILs select t.STD_HEALTHFACTOR.CODE);
            }
        }
    }
}
    